"use strict";

//Animation - начало

const observer = new IntersectionObserver((entries, obs) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
        entry.target.classList.add('animate');
        obs.unobserve(entry.target); // анимация запускается только один раз
        }
    });
}, { threshold: 0.3 });

document.querySelectorAll('.animate-on-scroll').forEach(el => observer.observe(el));

//Animation - конец

//BURGER-menu-начало

const burger = document.getElementById('burger');
const menu = document.getElementById('menu');
const links = menu.querySelectorAll('a');
const menuClose = document.getElementById('menuClose');

// Открыть / закрыть по бургеру
burger.addEventListener('click', () => {
    burger.classList.toggle('active');
    menu.classList.toggle('active');
});

// Закрыть по крестику внутри меню
menuClose.addEventListener('click', () => {
    menu.classList.remove('active');
    burger.classList.remove('active');
});

// Закрыть по ссылке
links.forEach(link => {
    link.addEventListener('click', () => {
    menu.classList.remove('active');
    burger.classList.remove('active');
    });
});

//BURGER-menu-конец