"use strict";

//Плашка close - начало
const closeButton = document.querySelector('.plashka__close');
const plashKa = document.querySelector('.plashka');

closeButton.onclick = function() {
    plashKa.remove();
}
//Плашка close - конец

//Search-начало
const searchIcon = document.getElementById('toggleSearch');
    const input = document.querySelector('.search-input');

    searchIcon.addEventListener('click', () => {
    input.classList.toggle('active');
    if (input.classList.contains('active')) {
        input.focus();
    }
    });
//Search-конец

//Animation - начало
const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
    if (entry.isIntersecting) {
        entry.target.classList.add('animate');
    } else {
        entry.target.classList.remove('animate');
    }
    });
}, {
    threshold: 0.3,
});

document.querySelectorAll('.animate-on-scroll').forEach(el => observer.observe(el));
//Animation - конец

//Slider - начало
const slider = document.getElementById("slider");
const slides = slider.querySelectorAll(".slide");
const pagination = document.getElementById("pagination");

const slideWidth = slides[0].offsetWidth + 20; // ширина + gap
let currentIndex = 0;
let interval;

  // === Создание точек пагинации ===
slides.forEach((_, index) => {
    const dot = document.createElement("span");
    dot.classList.add("pagination-dot");
    if (index === 0) dot.classList.add("active");
    pagination.appendChild(dot);
});

const dots = pagination.querySelectorAll(".pagination-dot");

function updatePagination() {
    dots.forEach(dot => dot.classList.remove("active"));
    if (dots[currentIndex]) dots[currentIndex].classList.add("active");
}

function scrollToSlide(index) {
    slider.scrollTo({
      left: index * slideWidth,
    behavior: "smooth"
    });
    currentIndex = index;
    updatePagination();
}

  // === Колесо мыши: скроллим по одному слайду
slider.addEventListener("wheel", (e) => {
    e.preventDefault();
    if (e.deltaY > 0) {
    if (currentIndex < slides.length - 1) {
        scrollToSlide(currentIndex + 1);
    } else {
        //scrollToSlide(0); // в начало
    }
    } else {
    if (currentIndex > 0) {
        scrollToSlide(currentIndex - 1);
    } else {
        //scrollToSlide(slides.length - 1); // в конец
    }
    }
});

  // === Автопрокрутка
    function autoScroll() {
    interval = setInterval(() => {
        if (currentIndex < slides.length - 1) {
        scrollToSlide(currentIndex + 1);
    } else {
        scrollToSlide(0);
    }
    }, 2000);
}

autoScroll();

  // Пауза автопрокрутки при наведении
slider.addEventListener("mouseenter", () => clearInterval(interval));
slider.addEventListener("mouseleave", () => autoScroll());

  // === Переход по пагинации (опционально)
dots.forEach((dot, index) => {
    dot.addEventListener("click", () => {
        scrollToSlide(index);
    });
});
//Slider - конец

//TYMER - начало
const daysEl = document.getElementById('days');
const hoursEl = document.getElementById('hours');
const minutesEl = document.getElementById('minutes');
const secondsEl = document.getElementById('seconds');

// Начальные значения
const initialDays = 2;
const initialHours = 12;
const initialMinutes = 45;
const initialSeconds = 5;

// Рассчитаем начальное время в секундах
let totalSeconds = (initialDays * 24 * 60 * 60) + (initialHours * 60 * 60) + (initialMinutes * 60) + initialSeconds;

function updateCountdown() {
  let days = Math.floor(totalSeconds / (24 * 60 * 60));
  let hours = Math.floor((totalSeconds % (24 * 60 * 60)) / (60 * 60));
  let minutes = Math.floor((totalSeconds % (60 * 60)) / 60);
    let seconds = totalSeconds % 60;

    daysEl.textContent = days.toString().padStart(2, '0');
    hoursEl.textContent = hours.toString().padStart(2, '0');
    minutesEl.textContent = minutes.toString().padStart(2, '0');
    secondsEl.textContent = seconds.toString().padStart(2, '0');

  // Уменьшаем общее количество секунд
    totalSeconds--;

  // Если таймер дошёл до конца, перезапускаем его
    if (totalSeconds < 0) {
    totalSeconds = (initialDays * 24 * 60 * 60) + (initialHours * 60 * 60) + (initialMinutes * 60) + initialSeconds;
    }
}

// Запуск обновления каждую секунду
setInterval(updateCountdown, 1000);

// И сразу запускаем первый раз
updateCountdown();

//TYMER - конец
